%------------------------------------------------------------------------------
% File     : LCL870^1 : TPTP v7.4.0. Bugfixed v5.0.0.
% Domain   : Logical Calculi (Modal logic)
% Problem  : The Barcan formula is valid in quantified modal logic K
% Version  : [Ben10] axioms.
% English  : 

% Refs     : [Ben10a] Benzmueller (2010), Email to Geoff Sutcliffe
%          : [Ben10b] Benzmueller (2010), Simple Type Theory as a Framework
% Source   : [Ben10a]
% Names    : Problem 32 [Ben10b]

% Status   : Theorem
% Rating   : 0.14 v7.4.0, 0.11 v7.2.0, 0.00 v7.1.0, 0.25 v7.0.0, 0.14 v6.4.0, 0.17 v6.3.0, 0.20 v6.2.0, 0.00 v6.1.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v5.3.0, 0.40 v5.2.0, 0.20 v5.0.0
% Syntax   : Number of formulae    :   66 (   0 unit;  34 type;  31 defn)
%            Number of atoms       :  234 (  36 equality; 132 variable)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :  134 (   4   ~;   4   |;   8   &; 110   @)
%                                         (   0 <=>;   8  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  172 ( 172   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   38 (  34   :;   0   =)
%            Number of variables   :   86 (   3 sgn;  29   !;   6   ?;  51   ^)
%                                         (  86   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
% Bugfixes : v5.0.0 - Bugfix to LCL013^0.ax
%------------------------------------------------------------------------------
%----Include the definitions for quantified multimodal logic
include('Axioms/LCL013^0.ax').
%------------------------------------------------------------------------------
%----Provide a constant for accesibility relation r
thf(r,type,(
    r: $i > $i > $o )).

thf(p,type,(
    p: mu > $i > $o )).

thf(ex1,conjecture,
    ( mvalid
    @ ( mimplies
      @ ( mforall_ind
        @ ^ [X: mu] :
            ( mbox @ r @ ( p @ X ) ) )
      @ ( mbox @ r
        @ ( mforall_ind
          @ ^ [X: mu] :
              ( p @ X ) ) ) ) )).

%------------------------------------------------------------------------------
